//								EJEMPLO 19
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//Introduccin al manejo del teclado.
//
//Haciendo uso de las rutinas incluidas en el fichero KBD2.C, se trata de leer el tecla-
//do y, visualizar sobre los leds de la puerta B el cdigo ASCII de la tecla pulsada. La 
//visualizacin se mantiene estable durante dos segundos hasta una nueva pulsacin.
//
//Se trata de un ejemplo en el que la Puerta B se reconfigura dinmicamente. Inicialmente es
//configurada como salida para presentacin del resultado. Posteriormente, la rutina de 
//exploracin del teclado reconfigura RB7-RB4 como salidas y RB3-RB0 como entradas


#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use delay(clock=4000000)
#include <kbd2.c>		//Incluir funciones de manejo del teclado

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);	//Puerta A Digital
	set_tris_a(0x3F);				//RA0-RA5 entradas
	set_tris_b(0x00);				//RB0-RB7 salidas	   
	
	while(1)
	{char k;
     k=kbd_getc();	// Comprueba el teclado, si k es 0 no se puls
     if(k)			// ninguna tecla, si no es 0 contiene el cdigo
     {				// ASCII de la tecla pulsada.
       output_b(k);	// Visuliza cdigo ASCII por la puerta A	
       delay_ms(2000);	//Temporiza 2 segundos
     }
  	}
}	
